/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public class PacketBuffer
extends ByteBuf {
    private final ByteBuf field_150794_a;

    public PacketBuffer(ByteBuf byteBuf) {
        this.field_150794_a = byteBuf;
    }

    public static int func_150790_a(int n) {
        for (\u2603 = 1; \u2603 < 5; ++\u2603) {
            if ((n & -1 << \u2603 * 7) != 0) continue;
            return \u2603;
        }
        return 5;
    }

    public <T> T func_240628_a_(Codec<T> codec) throws IOException {
        CompoundNBT compoundNBT = this.func_244273_m();
        DataResult \u26032 = codec.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT);
        if (\u26032.error().isPresent()) {
            throw new IOException("Failed to decode: " + ((DataResult.PartialResult)\u26032.error().get()).message() + " " + compoundNBT);
        }
        return \u26032.result().get();
    }

    public <T> void func_240629_a_(Codec<T> codec, T t) throws IOException {
        DataResult dataResult = codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, t);
        if (dataResult.error().isPresent()) {
            throw new IOException("Failed to encode: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + t);
        }
        this.func_150786_a((CompoundNBT)dataResult.result().get());
    }

    public PacketBuffer func_179250_a(byte[] byArray) {
        this.func_150787_b(byArray.length);
        this.writeBytes(byArray);
        return this;
    }

    public byte[] func_179251_a() {
        return this.func_189425_b(this.readableBytes());
    }

    public byte[] func_189425_b(int n) {
        \u2603 = this.func_150792_a();
        if (\u2603 > n) {
            throw new DecoderException("ByteArray with size " + \u2603 + " is bigger than allowed " + n);
        }
        byte[] byArray = new byte[\u2603];
        this.readBytes(byArray);
        return byArray;
    }

    public PacketBuffer func_186875_a(int[] nArray) {
        this.func_150787_b(nArray.length);
        for (int n : nArray) {
            this.func_150787_b(n);
        }
        return this;
    }

    public int[] func_186863_b() {
        return this.func_189424_c(this.readableBytes());
    }

    public int[] func_189424_c(int n) {
        \u2603 = this.func_150792_a();
        if (\u2603 > n) {
            throw new DecoderException("VarIntArray with size " + \u2603 + " is bigger than allowed " + n);
        }
        int[] nArray = new int[\u2603];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.func_150792_a();
        }
        return nArray;
    }

    public PacketBuffer func_186865_a(long[] lArray) {
        this.func_150787_b(lArray.length);
        for (long l : lArray) {
            this.writeLong(l);
        }
        return this;
    }

    public long[] func_186873_b(@Nullable long[] lArray) {
        return this.func_189423_a(lArray, this.readableBytes() / 8);
    }

    public long[] func_189423_a(@Nullable long[] lArray2, int n) {
        long[] lArray2;
        \u2603 = this.func_150792_a();
        if (lArray2 == null || lArray2.length != \u2603) {
            if (\u2603 > n) {
                throw new DecoderException("LongArray with size " + \u2603 + " is bigger than allowed " + n);
            }
            lArray2 = new long[\u2603];
        }
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = this.readLong();
        }
        return lArray2;
    }

    public BlockPos func_179259_c() {
        return BlockPos.func_218283_e(this.readLong());
    }

    public PacketBuffer func_179255_a(BlockPos blockPos) {
        this.writeLong(blockPos.func_218275_a());
        return this;
    }

    public SectionPos func_218667_g() {
        return SectionPos.func_218170_a(this.readLong());
    }

    public ITextComponent func_179258_d() {
        return ITextComponent.Serializer.func_240643_a_(this.func_150789_c(262144));
    }

    public PacketBuffer func_179256_a(ITextComponent iTextComponent) {
        return this.func_211400_a(ITextComponent.Serializer.func_150696_a(iTextComponent), 262144);
    }

    public <T extends Enum<T>> T func_179257_a(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.func_150792_a()];
    }

    public PacketBuffer func_179249_a(Enum<?> enum_) {
        return this.func_150787_b(enum_.ordinal());
    }

    public int func_150792_a() {
        int n = 0;
        \u2603 = 0;
        do {
            byte by = this.readByte();
            n |= (by & 0x7F) << \u2603++ * 7;
            if (\u2603 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((by & 0x80) == 128);
        return n;
    }

    public long func_179260_f() {
        long l = 0L;
        int \u26032 = 0;
        do {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << \u26032++ * 7;
            if (\u26032 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((by & 0x80) == 128);
        return l;
    }

    public PacketBuffer func_179252_a(UUID uUID) {
        this.writeLong(uUID.getMostSignificantBits());
        this.writeLong(uUID.getLeastSignificantBits());
        return this;
    }

    public UUID func_179253_g() {
        return new UUID(this.readLong(), this.readLong());
    }

    public PacketBuffer func_150787_b(int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeByte(n);
                return this;
            }
            this.writeByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public PacketBuffer func_179254_b(long l) {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeByte((int)l);
                return this;
            }
            this.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
    }

    public PacketBuffer func_150786_a(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT == null) {
            this.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a(compoundNBT, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            }
            catch (IOException iOException) {
                throw new EncoderException((Throwable)iOException);
            }
        }
        return this;
    }

    @Nullable
    public CompoundNBT func_150793_b() {
        return this.func_244272_a(new NBTSizeTracker(0x200000L));
    }

    @Nullable
    public CompoundNBT func_244273_m() {
        return this.func_244272_a(NBTSizeTracker.field_152451_a);
    }

    @Nullable
    public CompoundNBT func_244272_a(NBTSizeTracker nBTSizeTracker) {
        int n = this.readerIndex();
        byte \u26032 = this.readByte();
        if (\u26032 == 0) {
            return null;
        }
        this.readerIndex(n);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)this), nBTSizeTracker);
        }
        catch (IOException \u26033) {
            throw new EncoderException((Throwable)\u26033);
        }
    }

    public PacketBuffer func_150788_a(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            Item item = itemStack.func_77973_b();
            this.func_150787_b(Item.func_150891_b(item));
            this.writeByte(itemStack.func_190916_E());
            CompoundNBT \u26032 = null;
            if (item.func_77645_m() || item.func_77651_p()) {
                \u26032 = itemStack.func_77978_p();
            }
            this.func_150786_a(\u26032);
        }
        return this;
    }

    public ItemStack func_150791_c() {
        if (!this.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        int n = this.func_150792_a();
        byte \u26032 = this.readByte();
        ItemStack \u26033 = new ItemStack(Item.func_150899_d(n), \u26032);
        \u26033.func_77982_d(this.func_150793_b());
        return \u26033;
    }

    public String func_218666_n() {
        return this.func_150789_c(Short.MAX_VALUE);
    }

    public String func_150789_c(int n) {
        \u2603 = this.func_150792_a();
        if (\u2603 > n * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + \u2603 + " > " + n * 4 + ")");
        }
        if (\u2603 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String string = this.toString(this.readerIndex(), \u2603, StandardCharsets.UTF_8);
        this.readerIndex(this.readerIndex() + \u2603);
        if (string.length() > n) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + \u2603 + " > " + n + ")");
        }
        return string;
    }

    public PacketBuffer func_180714_a(String string) {
        return this.func_211400_a(string, Short.MAX_VALUE);
    }

    public PacketBuffer func_211400_a(String string, int n) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length > n) {
            throw new EncoderException("String too big (was " + byArray.length + " bytes encoded, max " + n + ")");
        }
        this.func_150787_b(byArray.length);
        this.writeBytes(byArray);
        return this;
    }

    public ResourceLocation func_192575_l() {
        return new ResourceLocation(this.func_150789_c(Short.MAX_VALUE));
    }

    public PacketBuffer func_192572_a(ResourceLocation resourceLocation) {
        this.func_180714_a(resourceLocation.toString());
        return this;
    }

    public Date func_192573_m() {
        return new Date(this.readLong());
    }

    public PacketBuffer func_192574_a(Date date) {
        this.writeLong(date.getTime());
        return this;
    }

    public BlockRayTraceResult func_218669_q() {
        BlockPos blockPos = this.func_179259_c();
        Direction \u26032 = this.func_179257_a(Direction.class);
        float \u26033 = this.readFloat();
        float \u26034 = this.readFloat();
        float \u26035 = this.readFloat();
        boolean \u26036 = this.readBoolean();
        return new BlockRayTraceResult(new Vector3d((double)blockPos.func_177958_n() + (double)\u26033, (double)blockPos.func_177956_o() + (double)\u26034, (double)blockPos.func_177952_p() + (double)\u26035), \u26032, blockPos, \u26036);
    }

    public void func_218668_a(BlockRayTraceResult blockRayTraceResult) {
        BlockPos blockPos = blockRayTraceResult.func_216350_a();
        this.func_179255_a(blockPos);
        this.func_179249_a(blockRayTraceResult.func_216354_b());
        Vector3d \u26032 = blockRayTraceResult.func_216347_e();
        this.writeFloat((float)(\u26032.field_72450_a - (double)blockPos.func_177958_n()));
        this.writeFloat((float)(\u26032.field_72448_b - (double)blockPos.func_177956_o()));
        this.writeFloat((float)(\u26032.field_72449_c - (double)blockPos.func_177952_p()));
        this.writeBoolean(blockRayTraceResult.func_216353_d());
    }

    public int capacity() {
        return this.field_150794_a.capacity();
    }

    public ByteBuf capacity(int n) {
        return this.field_150794_a.capacity(n);
    }

    public int maxCapacity() {
        return this.field_150794_a.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.field_150794_a.alloc();
    }

    public ByteOrder order() {
        return this.field_150794_a.order();
    }

    public ByteBuf order(ByteOrder byteOrder) {
        return this.field_150794_a.order(byteOrder);
    }

    public ByteBuf unwrap() {
        return this.field_150794_a.unwrap();
    }

    public boolean isDirect() {
        return this.field_150794_a.isDirect();
    }

    public boolean isReadOnly() {
        return this.field_150794_a.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.field_150794_a.asReadOnly();
    }

    public int readerIndex() {
        return this.field_150794_a.readerIndex();
    }

    public ByteBuf readerIndex(int n) {
        return this.field_150794_a.readerIndex(n);
    }

    public int writerIndex() {
        return this.field_150794_a.writerIndex();
    }

    public ByteBuf writerIndex(int n) {
        return this.field_150794_a.writerIndex(n);
    }

    public ByteBuf setIndex(int n, int n2) {
        return this.field_150794_a.setIndex(n, n2);
    }

    public int readableBytes() {
        return this.field_150794_a.readableBytes();
    }

    public int writableBytes() {
        return this.field_150794_a.writableBytes();
    }

    public int maxWritableBytes() {
        return this.field_150794_a.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.field_150794_a.isReadable();
    }

    public boolean isReadable(int n) {
        return this.field_150794_a.isReadable(n);
    }

    public boolean isWritable() {
        return this.field_150794_a.isWritable();
    }

    public boolean isWritable(int n) {
        return this.field_150794_a.isWritable(n);
    }

    public ByteBuf clear() {
        return this.field_150794_a.clear();
    }

    public ByteBuf markReaderIndex() {
        return this.field_150794_a.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        return this.field_150794_a.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        return this.field_150794_a.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        return this.field_150794_a.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        return this.field_150794_a.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        return this.field_150794_a.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int n) {
        return this.field_150794_a.ensureWritable(n);
    }

    public int ensureWritable(int n, boolean bl) {
        return this.field_150794_a.ensureWritable(n, bl);
    }

    public boolean getBoolean(int n) {
        return this.field_150794_a.getBoolean(n);
    }

    public byte getByte(int n) {
        return this.field_150794_a.getByte(n);
    }

    public short getUnsignedByte(int n) {
        return this.field_150794_a.getUnsignedByte(n);
    }

    public short getShort(int n) {
        return this.field_150794_a.getShort(n);
    }

    public short getShortLE(int n) {
        return this.field_150794_a.getShortLE(n);
    }

    public int getUnsignedShort(int n) {
        return this.field_150794_a.getUnsignedShort(n);
    }

    public int getUnsignedShortLE(int n) {
        return this.field_150794_a.getUnsignedShortLE(n);
    }

    public int getMedium(int n) {
        return this.field_150794_a.getMedium(n);
    }

    public int getMediumLE(int n) {
        return this.field_150794_a.getMediumLE(n);
    }

    public int getUnsignedMedium(int n) {
        return this.field_150794_a.getUnsignedMedium(n);
    }

    public int getUnsignedMediumLE(int n) {
        return this.field_150794_a.getUnsignedMediumLE(n);
    }

    public int getInt(int n) {
        return this.field_150794_a.getInt(n);
    }

    public int getIntLE(int n) {
        return this.field_150794_a.getIntLE(n);
    }

    public long getUnsignedInt(int n) {
        return this.field_150794_a.getUnsignedInt(n);
    }

    public long getUnsignedIntLE(int n) {
        return this.field_150794_a.getUnsignedIntLE(n);
    }

    public long getLong(int n) {
        return this.field_150794_a.getLong(n);
    }

    public long getLongLE(int n) {
        return this.field_150794_a.getLongLE(n);
    }

    public char getChar(int n) {
        return this.field_150794_a.getChar(n);
    }

    public float getFloat(int n) {
        return this.field_150794_a.getFloat(n);
    }

    public double getDouble(int n) {
        return this.field_150794_a.getDouble(n);
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf) {
        return this.field_150794_a.getBytes(n, byteBuf);
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        return this.field_150794_a.getBytes(n, byteBuf, n2);
    }

    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        return this.field_150794_a.getBytes(n, byteBuf, n2, n3);
    }

    public ByteBuf getBytes(int n, byte[] byArray) {
        return this.field_150794_a.getBytes(n, byArray);
    }

    public ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        return this.field_150794_a.getBytes(n, byArray, n2, n3);
    }

    public ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        return this.field_150794_a.getBytes(n, byteBuffer);
    }

    public ByteBuf getBytes(int n, OutputStream outputStream, int n2) throws IOException {
        return this.field_150794_a.getBytes(n, outputStream, n2);
    }

    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        return this.field_150794_a.getBytes(n, gatheringByteChannel, n2);
    }

    public int getBytes(int n, FileChannel fileChannel, long l, int n2) throws IOException {
        return this.field_150794_a.getBytes(n, fileChannel, l, n2);
    }

    public CharSequence getCharSequence(int n, int n2, Charset charset) {
        return this.field_150794_a.getCharSequence(n, n2, charset);
    }

    public ByteBuf setBoolean(int n, boolean bl) {
        return this.field_150794_a.setBoolean(n, bl);
    }

    public ByteBuf setByte(int n, int n2) {
        return this.field_150794_a.setByte(n, n2);
    }

    public ByteBuf setShort(int n, int n2) {
        return this.field_150794_a.setShort(n, n2);
    }

    public ByteBuf setShortLE(int n, int n2) {
        return this.field_150794_a.setShortLE(n, n2);
    }

    public ByteBuf setMedium(int n, int n2) {
        return this.field_150794_a.setMedium(n, n2);
    }

    public ByteBuf setMediumLE(int n, int n2) {
        return this.field_150794_a.setMediumLE(n, n2);
    }

    public ByteBuf setInt(int n, int n2) {
        return this.field_150794_a.setInt(n, n2);
    }

    public ByteBuf setIntLE(int n, int n2) {
        return this.field_150794_a.setIntLE(n, n2);
    }

    public ByteBuf setLong(int n, long l) {
        return this.field_150794_a.setLong(n, l);
    }

    public ByteBuf setLongLE(int n, long l) {
        return this.field_150794_a.setLongLE(n, l);
    }

    public ByteBuf setChar(int n, int n2) {
        return this.field_150794_a.setChar(n, n2);
    }

    public ByteBuf setFloat(int n, float f) {
        return this.field_150794_a.setFloat(n, f);
    }

    public ByteBuf setDouble(int n, double d) {
        return this.field_150794_a.setDouble(n, d);
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf) {
        return this.field_150794_a.setBytes(n, byteBuf);
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        return this.field_150794_a.setBytes(n, byteBuf, n2);
    }

    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        return this.field_150794_a.setBytes(n, byteBuf, n2, n3);
    }

    public ByteBuf setBytes(int n, byte[] byArray) {
        return this.field_150794_a.setBytes(n, byArray);
    }

    public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        return this.field_150794_a.setBytes(n, byArray, n2, n3);
    }

    public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        return this.field_150794_a.setBytes(n, byteBuffer);
    }

    public int setBytes(int n, InputStream inputStream, int n2) throws IOException {
        return this.field_150794_a.setBytes(n, inputStream, n2);
    }

    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) throws IOException {
        return this.field_150794_a.setBytes(n, scatteringByteChannel, n2);
    }

    public int setBytes(int n, FileChannel fileChannel, long l, int n2) throws IOException {
        return this.field_150794_a.setBytes(n, fileChannel, l, n2);
    }

    public ByteBuf setZero(int n, int n2) {
        return this.field_150794_a.setZero(n, n2);
    }

    public int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        return this.field_150794_a.setCharSequence(n, charSequence, charset);
    }

    public boolean readBoolean() {
        return this.field_150794_a.readBoolean();
    }

    public byte readByte() {
        return this.field_150794_a.readByte();
    }

    public short readUnsignedByte() {
        return this.field_150794_a.readUnsignedByte();
    }

    public short readShort() {
        return this.field_150794_a.readShort();
    }

    public short readShortLE() {
        return this.field_150794_a.readShortLE();
    }

    public int readUnsignedShort() {
        return this.field_150794_a.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.field_150794_a.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.field_150794_a.readMedium();
    }

    public int readMediumLE() {
        return this.field_150794_a.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.field_150794_a.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.field_150794_a.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.field_150794_a.readInt();
    }

    public int readIntLE() {
        return this.field_150794_a.readIntLE();
    }

    public long readUnsignedInt() {
        return this.field_150794_a.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.field_150794_a.readUnsignedIntLE();
    }

    public long readLong() {
        return this.field_150794_a.readLong();
    }

    public long readLongLE() {
        return this.field_150794_a.readLongLE();
    }

    public char readChar() {
        return this.field_150794_a.readChar();
    }

    public float readFloat() {
        return this.field_150794_a.readFloat();
    }

    public double readDouble() {
        return this.field_150794_a.readDouble();
    }

    public ByteBuf readBytes(int n) {
        return this.field_150794_a.readBytes(n);
    }

    public ByteBuf readSlice(int n) {
        return this.field_150794_a.readSlice(n);
    }

    public ByteBuf readRetainedSlice(int n) {
        return this.field_150794_a.readRetainedSlice(n);
    }

    public ByteBuf readBytes(ByteBuf byteBuf) {
        return this.field_150794_a.readBytes(byteBuf);
    }

    public ByteBuf readBytes(ByteBuf byteBuf, int n) {
        return this.field_150794_a.readBytes(byteBuf, n);
    }

    public ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        return this.field_150794_a.readBytes(byteBuf, n, n2);
    }

    public ByteBuf readBytes(byte[] byArray) {
        return this.field_150794_a.readBytes(byArray);
    }

    public ByteBuf readBytes(byte[] byArray, int n, int n2) {
        return this.field_150794_a.readBytes(byArray, n, n2);
    }

    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.field_150794_a.readBytes(byteBuffer);
    }

    public ByteBuf readBytes(OutputStream outputStream, int n) throws IOException {
        return this.field_150794_a.readBytes(outputStream, n);
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n) throws IOException {
        return this.field_150794_a.readBytes(gatheringByteChannel, n);
    }

    public CharSequence readCharSequence(int n, Charset charset) {
        return this.field_150794_a.readCharSequence(n, charset);
    }

    public int readBytes(FileChannel fileChannel, long l, int n) throws IOException {
        return this.field_150794_a.readBytes(fileChannel, l, n);
    }

    public ByteBuf skipBytes(int n) {
        return this.field_150794_a.skipBytes(n);
    }

    public ByteBuf writeBoolean(boolean bl) {
        return this.field_150794_a.writeBoolean(bl);
    }

    public ByteBuf writeByte(int n) {
        return this.field_150794_a.writeByte(n);
    }

    public ByteBuf writeShort(int n) {
        return this.field_150794_a.writeShort(n);
    }

    public ByteBuf writeShortLE(int n) {
        return this.field_150794_a.writeShortLE(n);
    }

    public ByteBuf writeMedium(int n) {
        return this.field_150794_a.writeMedium(n);
    }

    public ByteBuf writeMediumLE(int n) {
        return this.field_150794_a.writeMediumLE(n);
    }

    public ByteBuf writeInt(int n) {
        return this.field_150794_a.writeInt(n);
    }

    public ByteBuf writeIntLE(int n) {
        return this.field_150794_a.writeIntLE(n);
    }

    public ByteBuf writeLong(long l) {
        return this.field_150794_a.writeLong(l);
    }

    public ByteBuf writeLongLE(long l) {
        return this.field_150794_a.writeLongLE(l);
    }

    public ByteBuf writeChar(int n) {
        return this.field_150794_a.writeChar(n);
    }

    public ByteBuf writeFloat(float f) {
        return this.field_150794_a.writeFloat(f);
    }

    public ByteBuf writeDouble(double d) {
        return this.field_150794_a.writeDouble(d);
    }

    public ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.field_150794_a.writeBytes(byteBuf);
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        return this.field_150794_a.writeBytes(byteBuf, n);
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        return this.field_150794_a.writeBytes(byteBuf, n, n2);
    }

    public ByteBuf writeBytes(byte[] byArray) {
        return this.field_150794_a.writeBytes(byArray);
    }

    public ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        return this.field_150794_a.writeBytes(byArray, n, n2);
    }

    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.field_150794_a.writeBytes(byteBuffer);
    }

    public int writeBytes(InputStream inputStream, int n) throws IOException {
        return this.field_150794_a.writeBytes(inputStream, n);
    }

    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) throws IOException {
        return this.field_150794_a.writeBytes(scatteringByteChannel, n);
    }

    public int writeBytes(FileChannel fileChannel, long l, int n) throws IOException {
        return this.field_150794_a.writeBytes(fileChannel, l, n);
    }

    public ByteBuf writeZero(int n) {
        return this.field_150794_a.writeZero(n);
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        return this.field_150794_a.writeCharSequence(charSequence, charset);
    }

    public int indexOf(int n, int n2, byte by) {
        return this.field_150794_a.indexOf(n, n2, by);
    }

    public int bytesBefore(byte by) {
        return this.field_150794_a.bytesBefore(by);
    }

    public int bytesBefore(int n, byte by) {
        return this.field_150794_a.bytesBefore(n, by);
    }

    public int bytesBefore(int n, int n2, byte by) {
        return this.field_150794_a.bytesBefore(n, n2, by);
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        return this.field_150794_a.forEachByte(byteProcessor);
    }

    public int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        return this.field_150794_a.forEachByte(n, n2, byteProcessor);
    }

    public int forEachByteDesc(ByteProcessor byteProcessor) {
        return this.field_150794_a.forEachByteDesc(byteProcessor);
    }

    public int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        return this.field_150794_a.forEachByteDesc(n, n2, byteProcessor);
    }

    public ByteBuf copy() {
        return this.field_150794_a.copy();
    }

    public ByteBuf copy(int n, int n2) {
        return this.field_150794_a.copy(n, n2);
    }

    public ByteBuf slice() {
        return this.field_150794_a.slice();
    }

    public ByteBuf retainedSlice() {
        return this.field_150794_a.retainedSlice();
    }

    public ByteBuf slice(int n, int n2) {
        return this.field_150794_a.slice(n, n2);
    }

    public ByteBuf retainedSlice(int n, int n2) {
        return this.field_150794_a.retainedSlice(n, n2);
    }

    public ByteBuf duplicate() {
        return this.field_150794_a.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.field_150794_a.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.field_150794_a.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.field_150794_a.nioBuffer();
    }

    public ByteBuffer nioBuffer(int n, int n2) {
        return this.field_150794_a.nioBuffer(n, n2);
    }

    public ByteBuffer internalNioBuffer(int n, int n2) {
        return this.field_150794_a.internalNioBuffer(n, n2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.field_150794_a.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int n, int n2) {
        return this.field_150794_a.nioBuffers(n, n2);
    }

    public boolean hasArray() {
        return this.field_150794_a.hasArray();
    }

    public byte[] array() {
        return this.field_150794_a.array();
    }

    public int arrayOffset() {
        return this.field_150794_a.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.field_150794_a.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.field_150794_a.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.field_150794_a.toString(charset);
    }

    public String toString(int n, int n2, Charset charset) {
        return this.field_150794_a.toString(n, n2, charset);
    }

    public int hashCode() {
        return this.field_150794_a.hashCode();
    }

    public boolean equals(Object object) {
        return this.field_150794_a.equals(object);
    }

    public int compareTo(ByteBuf byteBuf) {
        return this.field_150794_a.compareTo(byteBuf);
    }

    public String toString() {
        return this.field_150794_a.toString();
    }

    public ByteBuf retain(int n) {
        return this.field_150794_a.retain(n);
    }

    public ByteBuf retain() {
        return this.field_150794_a.retain();
    }

    public ByteBuf touch() {
        return this.field_150794_a.touch();
    }

    public ByteBuf touch(Object object) {
        return this.field_150794_a.touch(object);
    }

    public int refCnt() {
        return this.field_150794_a.refCnt();
    }

    public boolean release() {
        return this.field_150794_a.release();
    }

    public boolean release(int n) {
        return this.field_150794_a.release(n);
    }
}

