/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.EndAttackTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.GetAngryTask;
import net.minecraft.entity.ai.brain.task.HuntCelebrationTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.PiglinIdleActivityTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RideEntityTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.ShootTargetTask;
import net.minecraft.entity.ai.brain.task.StopRidingEntityTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.AdmireItemTask;
import net.minecraft.entity.monster.piglin.FinishedHuntTask;
import net.minecraft.entity.monster.piglin.ForgetAdmiredItemTask;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.StartAdmiringItemTask;
import net.minecraft.entity.monster.piglin.StartHuntTask;
import net.minecraft.entity.monster.piglin.StopReachingItemTask;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;

public class PiglinTasks {
    public static final Item field_234444_a_ = Items.field_151043_k;
    private static final RangedInteger field_234445_b_ = TickRangeConverter.func_233037_a_(30, 120);
    private static final RangedInteger field_234446_c_ = TickRangeConverter.func_233037_a_(10, 40);
    private static final RangedInteger field_234447_d_ = TickRangeConverter.func_233037_a_(10, 30);
    private static final RangedInteger field_234448_e_ = TickRangeConverter.func_233037_a_(5, 20);
    private static final RangedInteger field_234449_f_ = TickRangeConverter.func_233037_a_(5, 7);
    private static final RangedInteger field_241418_g_ = TickRangeConverter.func_233037_a_(5, 7);
    private static final Set<Item> field_234450_g_ = ImmutableSet.of((Object)Items.field_151147_al, (Object)Items.field_151157_am);

    protected static Brain<?> func_234469_a_(PiglinEntity piglinEntity, Brain<PiglinEntity> brain) {
        PiglinTasks.func_234464_a_(brain);
        PiglinTasks.func_234485_b_(brain);
        PiglinTasks.func_234502_d_(brain);
        PiglinTasks.func_234488_b_(piglinEntity, brain);
        PiglinTasks.func_234495_c_(brain);
        PiglinTasks.func_234507_e_(brain);
        PiglinTasks.func_234511_f_(brain);
        brain.func_218199_a((Set<Activity>)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    protected static void func_234466_a_(PiglinEntity piglinEntity) {
        int n = field_234445_b_.func_233018_a_(piglinEntity.field_70170_p.field_73012_v);
        piglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, true, n);
    }

    private static void func_234464_a_(Brain<PiglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)new InteractWithDoorTask(), PiglinTasks.func_241428_d_(), PiglinTasks.func_234500_d_(), new StartAdmiringItemTask(), new AdmireItemTask(120), (Object)new EndAttackTask(300, PiglinTasks::func_234461_a_), new GetAngryTask()));
    }

    private static void func_234485_b_(Brain<PiglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221366_b, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of((Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), new ForgetAttackTargetTask<PiglinEntity>(AbstractPiglinEntity::func_242337_eM, PiglinTasks::func_234526_m_), new SupplementedTask<PiglinEntity>(PiglinEntity::func_234422_eK_, new StartHuntTask()), PiglinTasks.func_234493_c_(), PiglinTasks.func_234505_e_(), PiglinTasks.func_234458_a_(), PiglinTasks.func_234481_b_(), (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)));
    }

    private static void func_234488_b_(PiglinEntity piglinEntity, Brain<PiglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of(new FindNewAttackTargetTask(livingEntity -> !PiglinTasks.func_234504_d_(piglinEntity, livingEntity)), new SupplementedTask<PiglinEntity>(PiglinTasks::func_234494_c_, new AttackStrafingTask(5, 0.75f)), (Object)new MoveToTargetTask(1.0f), (Object)new AttackTargetTask(20), new ShootTargetTask(), new FinishedHuntTask(), new PredicateTask<PiglinEntity>(PiglinTasks::func_234525_l_, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void func_234495_c_(Brain<PiglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234622_l_, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of(PiglinTasks.func_234493_c_(), (Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), new ForgetAttackTargetTask<PiglinEntity>(AbstractPiglinEntity::func_242337_eM, PiglinTasks::func_234526_m_), new SupplementedTask<PiglinEntity>(piglinEntity -> !piglinEntity.func_234425_eN_(), new HuntCelebrationTask(2, 1.0f)), new SupplementedTask<PiglinEntity>(PiglinEntity::func_234425_eN_, new HuntCelebrationTask(4, 0.6f)), new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new WalkRandomlyTask(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new DummyTask(10, 20), (Object)1)))), MemoryModuleType.field_234083_Q_);
    }

    private static void func_234502_d_(Brain<PiglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234623_m_, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of(new PickupWantedItemTask<PiglinEntity>(PiglinTasks::func_234455_E_, 1.0f, true, 9), new ForgetAdmiredItemTask(9), new StopReachingItemTask(200, 200)), MemoryModuleType.field_234080_N_);
    }

    private static void func_234507_e_(Brain<PiglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234624_n_, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of(RunAwayTask.func_233965_b_(MemoryModuleType.field_234106_z_, 1.0f, 12, true), PiglinTasks.func_234458_a_(), PiglinTasks.func_234481_b_(), new PredicateTask<PiglinEntity>(PiglinTasks::func_234533_t_, MemoryModuleType.field_234106_z_)), MemoryModuleType.field_234106_z_);
    }

    private static void func_234511_f_(Brain<PiglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234625_o_, 10, (ImmutableList<Task<PiglinEntity>>)ImmutableList.of(new RideEntityTask(0.8f), (Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 8.0f), new SupplementedTask<PiglinEntity>(Entity::func_184218_aH, PiglinTasks.func_234458_a_()), new StopRidingEntityTask(8, PiglinTasks::func_234467_a_)), MemoryModuleType.field_234105_s_);
    }

    private static FirstShuffledTask<PiglinEntity> func_234458_a_() {
        return new FirstShuffledTask<PiglinEntity>((List<Pair<Task<PiglinEntity>, Integer>>)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static FirstShuffledTask<PiglinEntity> func_234481_b_() {
        return new FirstShuffledTask<PiglinEntity>((List<Pair<Task<PiglinEntity>, Integer>>)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.6f), (Object)2), (Object)Pair.of(InteractWithEntityTask.func_220445_a(EntityType.field_233591_ai_, 8, MemoryModuleType.field_220952_m, 0.6f, 2), (Object)2), (Object)Pair.of(new SupplementedTask<LivingEntity>(PiglinTasks::func_234514_g_, new WalkTowardsLookTargetTask(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static RunAwayTask<BlockPos> func_234493_c_() {
        return RunAwayTask.func_233963_a_(MemoryModuleType.field_234098_af_, 1.0f, 8, false);
    }

    private static PiglinIdleActivityTask<PiglinEntity, LivingEntity> func_241428_d_() {
        return new PiglinIdleActivityTask<PiglinEntity, LivingEntity>(PiglinEntity::func_70631_g_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234106_z_, field_241418_g_);
    }

    private static PiglinIdleActivityTask<PiglinEntity, LivingEntity> func_234500_d_() {
        return new PiglinIdleActivityTask<PiglinEntity, LivingEntity>(PiglinTasks::func_234525_l_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234106_z_, field_234449_f_);
    }

    protected static void func_234486_b_(PiglinEntity piglinEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        Activity \u26032 = brain.func_233716_f_().orElse(null);
        brain.func_233706_a_((List<Activity>)ImmutableList.of((Object)Activity.field_234623_m_, (Object)Activity.field_234621_k_, (Object)Activity.field_234624_n_, (Object)Activity.field_234622_l_, (Object)Activity.field_234625_o_, (Object)Activity.field_221366_b));
        Activity \u26033 = brain.func_233716_f_().orElse(null);
        if (\u26032 != \u26033) {
            PiglinTasks.func_241429_d_(piglinEntity).ifPresent(piglinEntity::func_241417_a_);
        }
        piglinEntity.func_213395_q(brain.func_218191_a(MemoryModuleType.field_234103_o_));
        if (!brain.func_218191_a(MemoryModuleType.field_234105_s_) && PiglinTasks.func_234522_j_(piglinEntity)) {
            piglinEntity.func_184210_p();
        }
        if (!brain.func_218191_a(MemoryModuleType.field_234083_Q_)) {
            brain.func_218189_b(MemoryModuleType.field_234084_R_);
        }
        piglinEntity.func_234442_u_(brain.func_218191_a(MemoryModuleType.field_234084_R_));
    }

    private static boolean func_234522_j_(PiglinEntity piglinEntity) {
        if (!piglinEntity.func_70631_g_()) {
            return false;
        }
        Entity entity = piglinEntity.func_184187_bx();
        return entity instanceof PiglinEntity && ((PiglinEntity)entity).func_70631_g_() || entity instanceof HoglinEntity && ((HoglinEntity)entity).func_70631_g_();
    }

    protected static void func_234470_a_(PiglinEntity piglinEntity2, ItemEntity itemEntity) {
        ItemStack \u26032;
        PiglinTasks.func_234531_r_(piglinEntity2);
        if (itemEntity.func_92059_d().func_77973_b() == Items.field_151074_bl) {
            piglinEntity2.func_71001_a(itemEntity, itemEntity.func_92059_d().func_190916_E());
            \u26032 = itemEntity.func_92059_d();
            itemEntity.func_70106_y();
        } else {
            PiglinEntity piglinEntity2;
            piglinEntity2.func_71001_a(itemEntity, 1);
            \u26032 = PiglinTasks.func_234465_a_(itemEntity);
        }
        Item item = \u26032.func_77973_b();
        if (PiglinTasks.func_234480_a_(item)) {
            piglinEntity2.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
            PiglinTasks.func_241427_c_(piglinEntity2, \u26032);
            PiglinTasks.func_234501_d_(piglinEntity2);
            return;
        }
        if (PiglinTasks.func_234499_c_(item) && !PiglinTasks.func_234538_z_(piglinEntity2)) {
            PiglinTasks.func_234536_x_(piglinEntity2);
            return;
        }
        boolean \u26033 = piglinEntity2.func_233665_g_(\u26032);
        if (\u26033) {
            return;
        }
        PiglinTasks.func_234498_c_(piglinEntity2, \u26032);
    }

    private static void func_241427_c_(PiglinEntity piglinEntity, ItemStack itemStack) {
        if (PiglinTasks.func_234454_D_(piglinEntity)) {
            piglinEntity.func_199701_a_(piglinEntity.func_184586_b(Hand.OFF_HAND));
        }
        piglinEntity.func_234439_n_(itemStack);
    }

    private static ItemStack func_234465_a_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        \u2603 = itemStack.func_77979_a(1);
        if (itemStack.func_190926_b()) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(itemStack);
        }
        return \u2603;
    }

    protected static void func_234477_a_(PiglinEntity piglinEntity2, boolean bl) {
        ItemStack itemStack = piglinEntity2.func_184586_b(Hand.OFF_HAND);
        piglinEntity2.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        if (piglinEntity2.func_242337_eM()) {
            boolean bl2 = PiglinTasks.func_234492_b_(itemStack.func_77973_b());
            if (bl && bl2) {
                PiglinTasks.func_234475_a_(piglinEntity2, PiglinTasks.func_234524_k_(piglinEntity2));
            } else if (!bl2 && !(\u2603 = piglinEntity2.func_233665_g_(itemStack))) {
                PiglinTasks.func_234498_c_(piglinEntity2, itemStack);
            }
        } else {
            PiglinEntity piglinEntity2;
            boolean \u26032 = piglinEntity2.func_233665_g_(itemStack);
            if (!\u26032) {
                ItemStack itemStack2 = piglinEntity2.func_184614_ca();
                if (PiglinTasks.func_234480_a_(itemStack2.func_77973_b())) {
                    PiglinTasks.func_234498_c_(piglinEntity2, itemStack2);
                } else {
                    PiglinTasks.func_234475_a_(piglinEntity2, Collections.singletonList(itemStack2));
                }
                piglinEntity2.func_234438_m_(itemStack);
            }
        }
    }

    protected static void func_234496_c_(PiglinEntity piglinEntity) {
        if (PiglinTasks.func_234451_A_(piglinEntity) && !piglinEntity.func_184592_cb().func_190926_b()) {
            piglinEntity.func_199701_a_(piglinEntity.func_184592_cb());
            piglinEntity.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        }
    }

    private static void func_234498_c_(PiglinEntity piglinEntity, ItemStack itemStack) {
        \u2603 = piglinEntity.func_234436_k_(itemStack);
        PiglinTasks.func_234490_b_(piglinEntity, Collections.singletonList(\u2603));
    }

    private static void func_234475_a_(PiglinEntity piglinEntity, List<ItemStack> list) {
        Optional<PlayerEntity> optional = piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j);
        if (optional.isPresent()) {
            PiglinTasks.func_234472_a_(piglinEntity, optional.get(), list);
        } else {
            PiglinTasks.func_234490_b_(piglinEntity, list);
        }
    }

    private static void func_234490_b_(PiglinEntity piglinEntity, List<ItemStack> list) {
        PiglinTasks.func_234476_a_(piglinEntity, list, PiglinTasks.func_234537_y_(piglinEntity));
    }

    private static void func_234472_a_(PiglinEntity piglinEntity, PlayerEntity playerEntity, List<ItemStack> list) {
        PiglinTasks.func_234476_a_(piglinEntity, list, playerEntity.func_213303_ch());
    }

    private static void func_234476_a_(PiglinEntity piglinEntity, List<ItemStack> list, Vector3d vector3d) {
        if (!list.isEmpty()) {
            piglinEntity.func_184609_a(Hand.OFF_HAND);
            for (ItemStack itemStack : list) {
                BrainUtil.func_233865_a_(piglinEntity, itemStack, vector3d.func_72441_c(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> func_234524_k_(PiglinEntity piglinEntity) {
        LootTable lootTable = piglinEntity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_237385_ay_);
        List<ItemStack> \u26032 = lootTable.func_216113_a(new LootContext.Builder((ServerWorld)piglinEntity.field_70170_p).func_216015_a(LootParameters.field_216281_a, piglinEntity).func_216023_a(piglinEntity.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
        return \u26032;
    }

    private static boolean func_234461_a_(LivingEntity livingEntity, LivingEntity livingEntity2) {
        if (livingEntity2.func_200600_R() != EntityType.field_233588_G_) {
            return false;
        }
        return new Random(livingEntity.field_70170_p.func_82737_E()).nextFloat() < 0.1f;
    }

    protected static boolean func_234474_a_(PiglinEntity piglinEntity, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item.func_206844_a(ItemTags.field_232902_M_)) {
            return false;
        }
        if (PiglinTasks.func_234453_C_(piglinEntity) && piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (PiglinTasks.func_234492_b_(item)) {
            return PiglinTasks.func_234455_E_(piglinEntity);
        }
        boolean \u26032 = piglinEntity.func_234437_l_(itemStack);
        if (item == Items.field_151074_bl) {
            return \u26032;
        }
        if (PiglinTasks.func_234499_c_(item)) {
            return !PiglinTasks.func_234538_z_(piglinEntity) && \u26032;
        }
        if (PiglinTasks.func_234480_a_(item)) {
            return PiglinTasks.func_234455_E_(piglinEntity) && \u26032;
        }
        return piglinEntity.func_234440_o_(itemStack);
    }

    protected static boolean func_234480_a_(Item item) {
        return item.func_206844_a(ItemTags.field_232903_N_);
    }

    private static boolean func_234467_a_(PiglinEntity piglinEntity, Entity entity) {
        if (entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            return !mobEntity.func_70631_g_() || !mobEntity.func_70089_S() || PiglinTasks.func_234517_h_(piglinEntity) || PiglinTasks.func_234517_h_(mobEntity) || mobEntity instanceof PiglinEntity && mobEntity.func_184187_bx() == null;
        }
        return false;
    }

    private static boolean func_234504_d_(PiglinEntity piglinEntity, LivingEntity livingEntity) {
        return PiglinTasks.func_234526_m_(piglinEntity).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    private static boolean func_234525_l_(PiglinEntity piglinEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        if (brain.func_218191_a(MemoryModuleType.field_234093_aa_)) {
            LivingEntity livingEntity = brain.func_218207_c(MemoryModuleType.field_234093_aa_).get();
            return piglinEntity.func_233562_a_(livingEntity, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> func_234526_m_(PiglinEntity piglinEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        if (PiglinTasks.func_234525_l_(piglinEntity)) {
            return Optional.empty();
        }
        Optional<LivingEntity> \u26032 = BrainUtil.func_233864_a_(piglinEntity, MemoryModuleType.field_234078_L_);
        if (\u26032.isPresent() && PiglinTasks.func_234506_e_(\u26032.get())) {
            return \u26032;
        }
        if (brain.func_218191_a(MemoryModuleType.field_234079_M_) && (\u26033 = brain.func_218207_c(MemoryModuleType.field_234102_l_)).isPresent()) {
            return \u26033;
        }
        Optional<LivingEntity> \u26033 = brain.func_218207_c(MemoryModuleType.field_234077_K_);
        if (\u26033.isPresent()) {
            return \u26033;
        }
        Optional<PlayerEntity> \u26034 = brain.func_218207_c(MemoryModuleType.field_234088_V_);
        if (\u26034.isPresent() && PiglinTasks.func_234506_e_(\u26034.get())) {
            return \u26034;
        }
        return Optional.empty();
    }

    public static void func_234478_a_(PlayerEntity playerEntity, boolean bl) {
        List<PiglinEntity> list = playerEntity.field_70170_p.func_217357_a(PiglinEntity.class, playerEntity.func_174813_aQ().func_186662_g(16.0));
        list.stream().filter(PiglinTasks::func_234520_i_).filter(piglinEntity -> !bl || BrainUtil.func_233876_c_(piglinEntity, playerEntity)).forEach(piglinEntity -> {
            if (piglinEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                PiglinTasks.func_241431_f_(piglinEntity, playerEntity);
            } else {
                PiglinTasks.func_234497_c_(piglinEntity, playerEntity);
            }
        });
    }

    public static ActionResultType func_234471_a_(PiglinEntity piglinEntity, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (PiglinTasks.func_234489_b_(piglinEntity, itemStack)) {
            \u2603 = itemStack.func_77979_a(1);
            PiglinTasks.func_241427_c_(piglinEntity, \u2603);
            PiglinTasks.func_234501_d_(piglinEntity);
            PiglinTasks.func_234531_r_(piglinEntity);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    protected static boolean func_234489_b_(PiglinEntity piglinEntity, ItemStack itemStack) {
        return !PiglinTasks.func_234453_C_(piglinEntity) && !PiglinTasks.func_234451_A_(piglinEntity) && piglinEntity.func_242337_eM() && PiglinTasks.func_234492_b_(itemStack.func_77973_b());
    }

    protected static void func_234468_a_(PiglinEntity piglinEntity, LivingEntity livingEntity) {
        if (livingEntity instanceof PiglinEntity) {
            return;
        }
        if (PiglinTasks.func_234454_D_(piglinEntity)) {
            PiglinTasks.func_234477_a_(piglinEntity, false);
        }
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        brain.func_218189_b(MemoryModuleType.field_234083_Q_);
        brain.func_218189_b(MemoryModuleType.field_234084_R_);
        brain.func_218189_b(MemoryModuleType.field_234080_N_);
        if (livingEntity instanceof PlayerEntity) {
            brain.func_233696_a_(MemoryModuleType.field_234081_O_, true, 400L);
        }
        PiglinTasks.func_234515_g_(piglinEntity).ifPresent(livingEntity2 -> {
            if (livingEntity2.func_200600_R() != livingEntity.func_200600_R()) {
                brain.func_218189_b(MemoryModuleType.field_234106_z_);
            }
        });
        if (piglinEntity.func_70631_g_()) {
            brain.func_233696_a_(MemoryModuleType.field_234106_z_, livingEntity, 100L);
            if (PiglinTasks.func_234506_e_(livingEntity)) {
                PiglinTasks.func_234487_b_(piglinEntity, livingEntity);
            }
            return;
        }
        if (livingEntity.func_200600_R() == EntityType.field_233588_G_ && PiglinTasks.func_234535_v_(piglinEntity)) {
            PiglinTasks.func_234521_i_(piglinEntity, livingEntity);
            PiglinTasks.func_234516_g_(piglinEntity, livingEntity);
            return;
        }
        PiglinTasks.func_234509_e_(piglinEntity, livingEntity);
    }

    protected static void func_234509_e_(AbstractPiglinEntity abstractPiglinEntity, LivingEntity livingEntity) {
        if (abstractPiglinEntity.func_213375_cj().func_218214_c(Activity.field_234624_n_)) {
            return;
        }
        if (!PiglinTasks.func_234506_e_(livingEntity)) {
            return;
        }
        if (BrainUtil.func_233861_a_(abstractPiglinEntity, livingEntity, 4.0)) {
            return;
        }
        if (livingEntity.func_200600_R() == EntityType.field_200729_aH && abstractPiglinEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
            PiglinTasks.func_241431_f_(abstractPiglinEntity, livingEntity);
            PiglinTasks.func_241430_f_(abstractPiglinEntity);
        } else {
            PiglinTasks.func_234497_c_(abstractPiglinEntity, livingEntity);
            PiglinTasks.func_234487_b_(abstractPiglinEntity, livingEntity);
        }
    }

    public static Optional<SoundEvent> func_241429_d_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_233716_f_().map(activity -> PiglinTasks.func_241422_a_(piglinEntity, activity));
    }

    private static SoundEvent func_241422_a_(PiglinEntity piglinEntity, Activity activity) {
        if (activity == Activity.field_234621_k_) {
            return SoundEvents.field_232789_kT_;
        }
        if (piglinEntity.func_242336_eL()) {
            return SoundEvents.field_232794_kY_;
        }
        if (activity == Activity.field_234624_n_ && PiglinTasks.func_234528_o_(piglinEntity)) {
            return SoundEvents.field_232794_kY_;
        }
        if (activity == Activity.field_234623_m_) {
            return SoundEvents.field_232787_kR_;
        }
        if (activity == Activity.field_234622_l_) {
            return SoundEvents.field_232790_kU_;
        }
        if (PiglinTasks.func_234510_f_(piglinEntity)) {
            return SoundEvents.field_232792_kW_;
        }
        if (PiglinTasks.func_234452_B_(piglinEntity)) {
            return SoundEvents.field_232794_kY_;
        }
        return SoundEvents.field_232788_kS_;
    }

    private static boolean func_234528_o_(PiglinEntity piglinEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_234106_z_)) {
            return false;
        }
        return brain.func_218207_c(MemoryModuleType.field_234106_z_).get().func_233562_a_(piglinEntity, 12.0);
    }

    protected static boolean func_234508_e_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234082_P_) || PiglinTasks.func_234529_p_(piglinEntity).stream().anyMatch(abstractPiglinEntity -> abstractPiglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234082_P_));
    }

    private static List<AbstractPiglinEntity> func_234529_p_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234090_X_).orElse((List<AbstractPiglinEntity>)ImmutableList.of());
    }

    private static List<AbstractPiglinEntity> func_234530_q_(AbstractPiglinEntity abstractPiglinEntity) {
        return abstractPiglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234089_W_).orElse((List<AbstractPiglinEntity>)ImmutableList.of());
    }

    public static boolean func_234460_a_(LivingEntity livingEntity) {
        Iterable<ItemStack> iterable = livingEntity.func_184193_aE();
        for (ItemStack itemStack : iterable) {
            Item item = itemStack.func_77973_b();
            if (!(item instanceof ArmorItem) || ((ArmorItem)item).func_200880_d() != ArmorMaterial.GOLD) continue;
            return true;
        }
        return false;
    }

    private static void func_234531_r_(PiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        piglinEntity.func_70661_as().func_75499_g();
    }

    private static RunSometimesTask<PiglinEntity> func_234505_e_() {
        return new RunSometimesTask<PiglinEntity>(new PiglinIdleActivityTask<PiglinEntity, Entity>(PiglinEntity::func_70631_g_, MemoryModuleType.field_234086_T_, MemoryModuleType.field_234105_s_, field_234447_d_), field_234446_c_);
    }

    protected static void func_234487_b_(AbstractPiglinEntity abstractPiglinEntity2, LivingEntity livingEntity) {
        PiglinTasks.func_234530_q_(abstractPiglinEntity2).forEach(abstractPiglinEntity -> {
            if (!(livingEntity.func_200600_R() != EntityType.field_233588_G_ || abstractPiglinEntity.func_234422_eK_() && ((HoglinEntity)livingEntity).func_234365_eM_())) {
                return;
            }
            PiglinTasks.func_234513_f_(abstractPiglinEntity, livingEntity);
        });
    }

    protected static void func_241430_f_(AbstractPiglinEntity abstractPiglinEntity2) {
        PiglinTasks.func_234530_q_(abstractPiglinEntity2).forEach(abstractPiglinEntity -> PiglinTasks.func_241432_i_(abstractPiglinEntity).ifPresent(playerEntity -> PiglinTasks.func_234497_c_(abstractPiglinEntity, playerEntity)));
    }

    protected static void func_234512_f_(PiglinEntity piglinEntity) {
        PiglinTasks.func_234529_p_(piglinEntity).forEach(PiglinTasks::func_234518_h_);
    }

    protected static void func_234497_c_(AbstractPiglinEntity abstractPiglinEntity, LivingEntity livingEntity) {
        if (!PiglinTasks.func_234506_e_(livingEntity)) {
            return;
        }
        abstractPiglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
        abstractPiglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234078_L_, livingEntity.func_110124_au(), 600L);
        if (livingEntity.func_200600_R() == EntityType.field_233588_G_ && abstractPiglinEntity.func_234422_eK_()) {
            PiglinTasks.func_234518_h_(abstractPiglinEntity);
        }
        if (livingEntity.func_200600_R() == EntityType.field_200729_aH && abstractPiglinEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
            abstractPiglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234079_M_, true, 600L);
        }
    }

    private static void func_241431_f_(AbstractPiglinEntity abstractPiglinEntity, LivingEntity livingEntity) {
        Optional<PlayerEntity> optional = PiglinTasks.func_241432_i_(abstractPiglinEntity);
        if (optional.isPresent()) {
            PiglinTasks.func_234497_c_(abstractPiglinEntity, optional.get());
        } else {
            PiglinTasks.func_234497_c_(abstractPiglinEntity, livingEntity);
        }
    }

    private static void func_234513_f_(AbstractPiglinEntity abstractPiglinEntity, LivingEntity livingEntity) {
        Optional<LivingEntity> optional = PiglinTasks.func_234532_s_(abstractPiglinEntity);
        LivingEntity \u26032 = BrainUtil.func_233867_a_(abstractPiglinEntity, optional, livingEntity);
        if (optional.isPresent() && optional.get() == \u26032) {
            return;
        }
        PiglinTasks.func_234497_c_(abstractPiglinEntity, \u26032);
    }

    private static Optional<LivingEntity> func_234532_s_(AbstractPiglinEntity abstractPiglinEntity) {
        return BrainUtil.func_233864_a_(abstractPiglinEntity, MemoryModuleType.field_234078_L_);
    }

    public static Optional<LivingEntity> func_234515_g_(PiglinEntity piglinEntity) {
        if (piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234106_z_)) {
            return piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234106_z_);
        }
        return Optional.empty();
    }

    public static Optional<PlayerEntity> func_241432_i_(AbstractPiglinEntity abstractPiglinEntity) {
        if (abstractPiglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234102_l_)) {
            return abstractPiglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234102_l_);
        }
        return Optional.empty();
    }

    private static void func_234516_g_(PiglinEntity piglinEntity, LivingEntity livingEntity) {
        PiglinTasks.func_234529_p_(piglinEntity).stream().filter(abstractPiglinEntity -> abstractPiglinEntity instanceof PiglinEntity).forEach(abstractPiglinEntity -> PiglinTasks.func_234519_h_((PiglinEntity)abstractPiglinEntity, livingEntity));
    }

    private static void func_234519_h_(PiglinEntity piglinEntity, LivingEntity livingEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        LivingEntity \u26032 = livingEntity;
        \u26032 = BrainUtil.func_233867_a_(piglinEntity, brain.func_218207_c(MemoryModuleType.field_234106_z_), \u26032);
        \u26032 = BrainUtil.func_233867_a_(piglinEntity, brain.func_218207_c(MemoryModuleType.field_234103_o_), \u26032);
        PiglinTasks.func_234521_i_(piglinEntity, \u26032);
    }

    private static boolean func_234533_t_(PiglinEntity piglinEntity) {
        Brain<PiglinEntity> brain = piglinEntity.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_234106_z_)) {
            return true;
        }
        LivingEntity \u26032 = brain.func_218207_c(MemoryModuleType.field_234106_z_).get();
        EntityType<?> \u26033 = \u26032.func_200600_R();
        if (\u26033 == EntityType.field_233588_G_) {
            return PiglinTasks.func_234534_u_(piglinEntity);
        }
        if (PiglinTasks.func_234459_a_(\u26033)) {
            return !brain.func_233708_b_(MemoryModuleType.field_234093_aa_, \u26032);
        }
        return false;
    }

    private static boolean func_234534_u_(PiglinEntity piglinEntity) {
        return !PiglinTasks.func_234535_v_(piglinEntity);
    }

    private static boolean func_234535_v_(PiglinEntity piglinEntity) {
        int n = piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234094_ab_).orElse(0) + 1;
        \u2603 = piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234095_ac_).orElse(0);
        return \u2603 > n;
    }

    private static void func_234521_i_(PiglinEntity piglinEntity, LivingEntity livingEntity) {
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_234078_L_);
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        piglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234106_z_, livingEntity, field_234448_e_.func_233018_a_(piglinEntity.field_70170_p.field_73012_v));
        PiglinTasks.func_234518_h_(piglinEntity);
    }

    protected static void func_234518_h_(AbstractPiglinEntity abstractPiglinEntity) {
        abstractPiglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, true, field_234445_b_.func_233018_a_(abstractPiglinEntity.field_70170_p.field_73012_v));
    }

    private static void func_234536_x_(PiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234097_ae_, true, 200L);
    }

    private static Vector3d func_234537_y_(PiglinEntity piglinEntity) {
        Vector3d vector3d = RandomPositionGenerator.func_191377_b(piglinEntity, 4, 2);
        return vector3d == null ? piglinEntity.func_213303_ch() : vector3d;
    }

    private static boolean func_234538_z_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234097_ae_);
    }

    protected static boolean func_234520_i_(AbstractPiglinEntity abstractPiglinEntity) {
        return abstractPiglinEntity.func_213375_cj().func_218214_c(Activity.field_221366_b);
    }

    private static boolean func_234494_c_(LivingEntity livingEntity) {
        return livingEntity.func_233631_a_(Items.field_222114_py);
    }

    private static void func_234501_d_(LivingEntity livingEntity) {
        livingEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234080_N_, true, 120L);
    }

    private static boolean func_234451_A_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234080_N_);
    }

    private static boolean func_234492_b_(Item item) {
        return item == field_234444_a_;
    }

    private static boolean func_234499_c_(Item item) {
        return field_234450_g_.contains(item);
    }

    private static boolean func_234506_e_(LivingEntity livingEntity) {
        return EntityPredicates.field_233583_f_.test(livingEntity);
    }

    private static boolean func_234452_B_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234098_af_);
    }

    private static boolean func_234510_f_(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234096_ad_);
    }

    private static boolean func_234514_g_(LivingEntity livingEntity) {
        return !PiglinTasks.func_234510_f_(livingEntity);
    }

    public static boolean func_234482_b_(LivingEntity livingEntity) {
        return livingEntity.func_200600_R() == EntityType.field_200729_aH && livingEntity.func_233634_a_(PiglinTasks::func_234480_a_);
    }

    private static boolean func_234453_C_(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234081_O_);
    }

    private static boolean func_234517_h_(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220957_r);
    }

    private static boolean func_234454_D_(PiglinEntity piglinEntity) {
        return !piglinEntity.func_184592_cb().func_190926_b();
    }

    private static boolean func_234455_E_(PiglinEntity piglinEntity) {
        return piglinEntity.func_184592_cb().func_190926_b() || !PiglinTasks.func_234480_a_(piglinEntity.func_184592_cb().func_77973_b());
    }

    public static boolean func_234459_a_(EntityType entityType) {
        return entityType == EntityType.field_233592_ba_ || entityType == EntityType.field_233590_aW_;
    }
}

