/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.PackLoadingManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ResourcePackList;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackScreen
extends Screen {
    private static final Logger field_238883_a_ = LogManager.getLogger();
    private static final ITextComponent field_238884_b_ = new TranslationTextComponent("pack.dropInfo").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent field_238885_c_ = new TranslationTextComponent("pack.folderInfo");
    private static final ResourceLocation field_243391_p = new ResourceLocation("textures/misc/unknown_pack.png");
    private final PackLoadingManager field_238887_q_;
    private final Screen field_238888_r_;
    @Nullable
    private PackDirectoryWatcher field_243392_s;
    private long field_243393_t;
    private net.minecraft.client.gui.widget.list.ResourcePackList field_238891_u_;
    private net.minecraft.client.gui.widget.list.ResourcePackList field_238892_v_;
    private final File field_241817_w_;
    private Button field_238894_x_;
    private final Map<String, ResourceLocation> field_243394_y = Maps.newHashMap();

    public PackScreen(Screen screen, ResourcePackList resourcePackList, Consumer<ResourcePackList> consumer, File file, ITextComponent iTextComponent) {
        super(iTextComponent);
        this.field_238888_r_ = screen;
        this.field_238887_q_ = new PackLoadingManager(this::func_238904_g_, this::func_243395_a, resourcePackList, consumer);
        this.field_241817_w_ = file;
        this.field_243392_s = PackDirectoryWatcher.func_243403_a(file);
    }

    @Override
    public void func_231175_as__() {
        this.field_238887_q_.func_241618_c_();
        this.field_230706_i_.func_147108_a(this.field_238888_r_);
        this.func_243399_k();
    }

    private void func_243399_k() {
        if (this.field_243392_s != null) {
            try {
                this.field_243392_s.close();
                this.field_243392_s = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void func_231160_c_() {
        this.field_238894_x_ = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 48, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 48, 150, 20, new TranslationTextComponent("pack.openFolder"), button -> Util.func_110647_a().func_195641_a(this.field_241817_w_), (button, matrixStack, n, n2) -> this.func_238652_a_(matrixStack, field_238885_c_, n, n2)));
        this.field_238891_u_ = new net.minecraft.client.gui.widget.list.ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, new TranslationTextComponent("pack.available.title"));
        this.field_238891_u_.func_230959_g_(this.field_230708_k_ / 2 - 4 - 200);
        this.field_230705_e_.add(this.field_238891_u_);
        this.field_238892_v_ = new net.minecraft.client.gui.widget.list.ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, new TranslationTextComponent("pack.selected.title"));
        this.field_238892_v_.func_230959_g_(this.field_230708_k_ / 2 + 4);
        this.field_230705_e_.add(this.field_238892_v_);
        this.func_238906_l_();
    }

    @Override
    public void func_231023_e_() {
        if (this.field_243392_s != null) {
            try {
                if (this.field_243392_s.func_243402_a()) {
                    this.field_243393_t = 20L;
                }
            }
            catch (IOException iOException) {
                field_238883_a_.warn("Failed to poll for directory {} changes, stopping", (Object)this.field_241817_w_);
                this.func_243399_k();
            }
        }
        if (this.field_243393_t > 0L && --this.field_243393_t == 0L) {
            this.func_238906_l_();
        }
    }

    private void func_238904_g_() {
        this.func_238899_a_(this.field_238892_v_, this.field_238887_q_.func_238869_b_());
        this.func_238899_a_(this.field_238891_u_, this.field_238887_q_.func_238865_a_());
        this.field_238894_x_.field_230693_o_ = !this.field_238892_v_.func_231039_at__().isEmpty();
    }

    private void func_238899_a_(net.minecraft.client.gui.widget.list.ResourcePackList resourcePackList, Stream<PackLoadingManager.IPack> stream) {
        resourcePackList.func_231039_at__().clear();
        stream.forEach(iPack -> resourcePackList.func_231039_at__().add(new ResourcePackList.ResourcePackEntry(this.field_230706_i_, resourcePackList, this, (PackLoadingManager.IPack)iPack)));
    }

    private void func_238906_l_() {
        this.field_238887_q_.func_241619_d_();
        this.func_238904_g_();
        this.field_243393_t = 0L;
        this.field_243394_y.clear();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_231165_f_(0);
        this.field_238891_u_.func_230430_a_(matrixStack, n, n2, f);
        this.field_238892_v_.func_230430_a_(matrixStack, n, n2, f);
        PackScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 8, 0xFFFFFF);
        PackScreen.func_238472_a_(matrixStack, this.field_230712_o_, field_238884_b_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        super.func_230430_a_(matrixStack, n, n2, f);
    }

    protected static void func_238895_a_(Minecraft minecraft, List<Path> list, Path path) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        list.forEach(path2 -> {
            try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                stream.forEach(path3 -> {
                    try {
                        Util.func_240984_a_(path2.getParent(), path, path3);
                    }
                    catch (IOException iOException) {
                        field_238883_a_.warn("Failed to copy datapack file  from {} to {}", path3, (Object)path, (Object)iOException);
                        mutableBoolean.setTrue();
                    }
                });
            }
            catch (IOException iOException) {
                field_238883_a_.warn("Failed to copy datapack file from {} to {}", path2, (Object)path);
                mutableBoolean.setTrue();
            }
        });
        if (mutableBoolean.isTrue()) {
            SystemToast.func_238539_c_(minecraft, path.toString());
        }
    }

    @Override
    public void func_230476_a_(List<Path> list) {
        String string = list.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_230706_i_.func_147108_a(new ConfirmScreen(bl -> {
            if (bl) {
                PackScreen.func_238895_a_(this.field_230706_i_, list, this.field_241817_w_.toPath());
                this.func_238906_l_();
            }
            this.field_230706_i_.func_147108_a(this);
        }, new TranslationTextComponent("pack.dropConfirm"), new StringTextComponent(string)));
    }

    /*
     * Exception decompiling
     */
    private ResourceLocation func_243397_a(TextureManager \u2603, ResourcePackInfo \u2603) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResourceLocation func_243395_a(ResourcePackInfo resourcePackInfo) {
        return this.field_243394_y.computeIfAbsent(resourcePackInfo.func_195790_f(), string -> this.func_243397_a(this.field_230706_i_.func_110434_K(), resourcePackInfo));
    }

    static class PackDirectoryWatcher
    implements AutoCloseable {
        private final WatchService field_243400_a;
        private final Path field_243401_b;

        public PackDirectoryWatcher(File file) throws IOException {
            this.field_243401_b = file.toPath();
            this.field_243400_a = this.field_243401_b.getFileSystem().newWatchService();
            try {
                this.func_243404_a(this.field_243401_b);
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.field_243401_b);){
                    for (Path path : directoryStream) {
                        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.func_243404_a(path);
                    }
                }
            }
            catch (Exception exception) {
                this.field_243400_a.close();
                throw exception;
            }
        }

        @Nullable
        public static PackDirectoryWatcher func_243403_a(File file) {
            try {
                return new PackDirectoryWatcher(file);
            }
            catch (IOException iOException) {
                field_238883_a_.warn("Failed to initialize pack directory {} monitoring", (Object)file, (Object)iOException);
                return null;
            }
        }

        private void func_243404_a(Path path) throws IOException {
            path.register(this.field_243400_a, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        public boolean func_243402_a() throws IOException {
            boolean bl = false;
            while ((watchKey = this.field_243400_a.poll()) != null) {
                WatchKey watchKey;
                List<WatchEvent<?>> list = watchKey.pollEvents();
                for (WatchEvent<?> watchEvent : list) {
                    bl = true;
                    if (watchKey.watchable() != this.field_243401_b || watchEvent.kind() != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(\u2603 = this.field_243401_b.resolve((Path)watchEvent.context()), LinkOption.NOFOLLOW_LINKS)) continue;
                    this.func_243404_a(\u2603);
                }
                watchKey.reset();
            }
            return bl;
        }

        @Override
        public void close() throws IOException {
            this.field_243400_a.close();
        }
    }
}

