/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;

public class PlayerTabOverlayGui
extends AbstractGui {
    private static final Ordering<NetworkPlayerInfo> field_175252_a = Ordering.from((Comparator)new PlayerComparator());
    private final Minecraft field_175250_f;
    private final IngameGui field_175251_g;
    private ITextComponent field_175255_h;
    private ITextComponent field_175256_i;
    private long field_175253_j;
    private boolean field_175254_k;

    public PlayerTabOverlayGui(Minecraft minecraft, IngameGui ingameGui) {
        this.field_175250_f = minecraft;
        this.field_175251_g = ingameGui;
    }

    public ITextComponent func_200262_a(NetworkPlayerInfo networkPlayerInfo) {
        if (networkPlayerInfo.func_178854_k() != null) {
            return this.func_238524_a_(networkPlayerInfo, networkPlayerInfo.func_178854_k().func_230532_e_());
        }
        return this.func_238524_a_(networkPlayerInfo, ScorePlayerTeam.func_237500_a_(networkPlayerInfo.func_178850_i(), new StringTextComponent(networkPlayerInfo.func_178845_a().getName())));
    }

    private ITextComponent func_238524_a_(NetworkPlayerInfo networkPlayerInfo, IFormattableTextComponent iFormattableTextComponent) {
        return networkPlayerInfo.func_178848_b() == GameType.SPECTATOR ? iFormattableTextComponent.func_240699_a_(TextFormatting.ITALIC) : iFormattableTextComponent;
    }

    public void func_175246_a(boolean bl) {
        if (bl && !this.field_175254_k) {
            this.field_175253_j = Util.func_211177_b();
        }
        this.field_175254_k = bl;
    }

    public void func_238523_a_(MatrixStack matrixStack2, int n, Scoreboard scoreboard, @Nullable ScoreObjective scoreObjective) {
        int n3;
        ClientPlayNetHandler clientPlayNetHandler = this.field_175250_f.field_71439_g.field_71174_a;
        List \u26032 = field_175252_a.sortedCopy(clientPlayNetHandler.func_175106_d());
        int \u26033 = 0;
        int \u26034 = 0;
        for (NetworkPlayerInfo networkPlayerInfo : \u26032) {
            int n4 = this.field_175250_f.field_71466_p.func_238414_a_(this.func_200262_a(networkPlayerInfo));
            \u26033 = Math.max(\u26033, n4);
            if (scoreObjective == null || scoreObjective.func_199865_f() == ScoreCriteria.RenderType.HEARTS) continue;
            n4 = this.field_175250_f.field_71466_p.func_78256_a(" " + scoreboard.func_96529_a(networkPlayerInfo.func_178845_a().getName(), scoreObjective).func_96652_c());
            \u26034 = Math.max(\u26034, n4);
        }
        \u26032 = \u26032.subList(0, Math.min(\u26032.size(), 80));
        int n2 = n3 = \u26032.size();
        \u2603 = 1;
        while (n2 > 20) {
            n2 = (n3 + ++\u2603 - 1) / \u2603;
        }
        boolean bl = \u2603 = this.field_175250_f.func_71387_A() || this.field_175250_f.func_147114_u().func_147298_b().func_179292_f();
        \u2603 = scoreObjective != null ? (scoreObjective.func_199865_f() == ScoreCriteria.RenderType.HEARTS ? 90 : \u26034) : 0;
        \u2603 = Math.min(\u2603 * ((\u2603 ? 9 : 0) + \u26033 + \u2603 + 13), n - 50) / \u2603;
        \u2603 = n / 2 - (\u2603 * \u2603 + (\u2603 - 1) * 5) / 2;
        int n5 = 10;
        int n22 = \u2603 * \u2603 + (\u2603 - 1) * 5;
        List<IReorderingProcessor> \u26035 = null;
        if (this.field_175256_i != null) {
            \u26035 = this.field_175250_f.field_71466_p.func_238425_b_(this.field_175256_i, n - 50);
            for (IReorderingProcessor iReorderingProcessor : \u26035) {
                n22 = Math.max(n22, this.field_175250_f.field_71466_p.func_243245_a(iReorderingProcessor));
            }
        }
        List<IReorderingProcessor> list = null;
        if (this.field_175255_h != null) {
            list = this.field_175250_f.field_71466_p.func_238425_b_(this.field_175255_h, n - 50);
            for (IReorderingProcessor iReorderingProcessor : list) {
                n22 = Math.max(n22, this.field_175250_f.field_71466_p.func_243245_a(iReorderingProcessor));
            }
        }
        if (\u26035 != null) {
            PlayerTabOverlayGui.func_238467_a_(matrixStack2, n / 2 - n22 / 2 - 1, n5 - 1, n / 2 + n22 / 2 + 1, n5 + \u26035.size() * this.field_175250_f.field_71466_p.field_78288_b, Integer.MIN_VALUE);
            for (IReorderingProcessor iReorderingProcessor : \u26035) {
                int n4 = this.field_175250_f.field_71466_p.func_243245_a(iReorderingProcessor);
                this.field_175250_f.field_71466_p.func_238407_a_(matrixStack2, iReorderingProcessor, n / 2 - n4 / 2, n5, -1);
                n5 += this.field_175250_f.field_71466_p.field_78288_b;
            }
            ++n5;
        }
        PlayerTabOverlayGui.func_238467_a_(matrixStack2, n / 2 - n22 / 2 - 1, n5 - 1, n / 2 + n22 / 2 + 1, n5 + n2 * 9, Integer.MIN_VALUE);
        int n6 = this.field_175250_f.field_71474_y.func_216839_a(0x20FFFFFF);
        for (int i = 0; i < n3; ++i) {
            int n62 = i / n2;
            int n8 = i % n2;
            \u2603 = \u2603 + n62 * \u2603 + n62 * 5;
            \u2603 = n5 + n8 * 9;
            PlayerTabOverlayGui.func_238467_a_(matrixStack2, \u2603, \u2603, \u2603 + \u2603, \u2603 + 8, n6);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (i >= \u26032.size()) continue;
            NetworkPlayerInfo networkPlayerInfo = (NetworkPlayerInfo)\u26032.get(i);
            GameProfile \u26037 = networkPlayerInfo.func_178845_a();
            if (\u2603) {
                PlayerEntity playerEntity = this.field_175250_f.field_71441_e.func_217371_b(\u26037.getId());
                boolean \u26038 = playerEntity != null && playerEntity.func_175148_a(PlayerModelPart.CAPE) && ("Dinnerbone".equals(\u26037.getName()) || "Grumm".equals(\u26037.getName()));
                this.field_175250_f.func_110434_K().func_110577_a(networkPlayerInfo.func_178837_g());
                int \u26039 = 8 + (\u26038 ? 8 : 0);
                int \u260310 = 8 * (\u26038 ? -1 : 1);
                AbstractGui.func_238466_a_(matrixStack2, \u2603, \u2603, 8, 8, 8.0f, \u26039, 8, \u260310, 64, 64);
                if (playerEntity != null && playerEntity.func_175148_a(PlayerModelPart.HAT)) {
                    int n7 = 8 + (\u26038 ? 8 : 0);
                    \u2603 = 8 * (\u26038 ? -1 : 1);
                    AbstractGui.func_238466_a_(matrixStack2, \u2603, \u2603, 8, 8, 40.0f, n7, 8, \u2603, 64, 64);
                }
                \u2603 += 9;
            }
            this.field_175250_f.field_71466_p.func_243246_a(matrixStack2, this.func_200262_a(networkPlayerInfo), \u2603, \u2603, networkPlayerInfo.func_178848_b() == GameType.SPECTATOR ? -1862270977 : -1);
            if (scoreObjective != null && networkPlayerInfo.func_178848_b() != GameType.SPECTATOR && (\u2603 = (\u2603 = \u2603 + \u26033 + 1) + \u2603) - \u2603 > 5) {
                this.func_175247_a_(scoreObjective, \u2603, \u26037.getName(), \u2603, \u2603, networkPlayerInfo, matrixStack2);
            }
            this.func_238522_a_(matrixStack2, \u2603, \u2603 - (\u2603 ? 9 : 0), \u2603, networkPlayerInfo);
        }
        if (list != null) {
            PlayerTabOverlayGui.func_238467_a_(matrixStack2, n / 2 - n22 / 2 - 1, (n5 += n2 * 9 + 1) - 1, n / 2 + n22 / 2 + 1, n5 + list.size() * this.field_175250_f.field_71466_p.field_78288_b, Integer.MIN_VALUE);
            for (IReorderingProcessor iReorderingProcessor : list) {
                \u2603 = this.field_175250_f.field_71466_p.func_243245_a(iReorderingProcessor);
                this.field_175250_f.field_71466_p.func_238407_a_(matrixStack2, iReorderingProcessor, n / 2 - \u2603 / 2, n5, -1);
                n5 += this.field_175250_f.field_71466_p.field_78288_b;
            }
        }
    }

    protected void func_238522_a_(MatrixStack matrixStack, int n, int n2, int n3, NetworkPlayerInfo networkPlayerInfo) {
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_175250_f.func_110434_K().func_110577_a(field_230665_h_);
        boolean bl = false;
        int \u26032 = networkPlayerInfo.func_178853_c() < 0 ? 5 : (networkPlayerInfo.func_178853_c() < 150 ? 0 : (networkPlayerInfo.func_178853_c() < 300 ? 1 : (networkPlayerInfo.func_178853_c() < 600 ? 2 : (networkPlayerInfo.func_178853_c() < 1000 ? 3 : 4))));
        this.func_230926_e_(this.func_230927_p_() + 100);
        this.func_238474_b_(matrixStack, n2 + n - 11, n3, 0, 176 + \u26032 * 8, 10, 8);
        this.func_230926_e_(this.func_230927_p_() - 100);
    }

    private void func_175247_a_(ScoreObjective scoreObjective, int n, String string, int n2, int n3, NetworkPlayerInfo networkPlayerInfo, MatrixStack matrixStack) {
        int n4 = scoreObjective.func_96682_a().func_96529_a(string, scoreObjective).func_96652_c();
        if (scoreObjective.func_199865_f() == ScoreCriteria.RenderType.HEARTS) {
            this.field_175250_f.func_110434_K().func_110577_a(field_230665_h_);
            long l = Util.func_211177_b();
            if (this.field_175253_j == networkPlayerInfo.func_178855_p()) {
                if (n4 < networkPlayerInfo.func_178835_l()) {
                    networkPlayerInfo.func_178846_a(l);
                    networkPlayerInfo.func_178844_b(this.field_175251_g.func_73834_c() + 20);
                } else if (n4 > networkPlayerInfo.func_178835_l()) {
                    networkPlayerInfo.func_178846_a(l);
                    networkPlayerInfo.func_178844_b(this.field_175251_g.func_73834_c() + 10);
                }
            }
            if (l - networkPlayerInfo.func_178847_n() > 1000L || this.field_175253_j != networkPlayerInfo.func_178855_p()) {
                networkPlayerInfo.func_178836_b(n4);
                networkPlayerInfo.func_178857_c(n4);
                networkPlayerInfo.func_178846_a(l);
            }
            networkPlayerInfo.func_178843_c(this.field_175253_j);
            networkPlayerInfo.func_178836_b(n4);
            int \u26032 = MathHelper.func_76123_f((float)Math.max(n4, networkPlayerInfo.func_178860_m()) / 2.0f);
            int \u26033 = Math.max(MathHelper.func_76123_f(n4 / 2), Math.max(MathHelper.func_76123_f(networkPlayerInfo.func_178860_m() / 2), 10));
            boolean bl = \u2603 = networkPlayerInfo.func_178858_o() > (long)this.field_175251_g.func_73834_c() && (networkPlayerInfo.func_178858_o() - (long)this.field_175251_g.func_73834_c()) / 3L % 2L == 1L;
            if (\u26032 > 0) {
                int n5 = MathHelper.func_76141_d(Math.min((float)(n3 - n2 - 4) / (float)\u26033, 9.0f));
                if (n5 > 3) {
                    for (\u2603 = \u26032; \u2603 < \u26033; ++\u2603) {
                        this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, \u2603 ? 25 : 16, 0, 9, 9);
                    }
                    for (\u2603 = 0; \u2603 < \u26032; ++\u2603) {
                        this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, \u2603 ? 25 : 16, 0, 9, 9);
                        if (\u2603) {
                            if (\u2603 * 2 + 1 < networkPlayerInfo.func_178860_m()) {
                                this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, 70, 0, 9, 9);
                            }
                            if (\u2603 * 2 + 1 == networkPlayerInfo.func_178860_m()) {
                                this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, 79, 0, 9, 9);
                            }
                        }
                        if (\u2603 * 2 + 1 < n4) {
                            this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, \u2603 >= 10 ? 160 : 52, 0, 9, 9);
                        }
                        if (\u2603 * 2 + 1 != n4) continue;
                        this.func_238474_b_(matrixStack, n2 + \u2603 * n5, n, \u2603 >= 10 ? 169 : 61, 0, 9, 9);
                    }
                } else {
                    float f = MathHelper.func_76131_a((float)n4 / 20.0f, 0.0f, 1.0f);
                    int \u26034 = (int)((1.0f - f) * 255.0f) << 16 | (int)(f * 255.0f) << 8;
                    String \u26035 = "" + (float)n4 / 2.0f;
                    if (n3 - this.field_175250_f.field_71466_p.func_78256_a(\u26035 + "hp") >= n2) {
                        \u26035 = \u26035 + "hp";
                    }
                    this.field_175250_f.field_71466_p.func_238405_a_(matrixStack, \u26035, (n3 + n2) / 2 - this.field_175250_f.field_71466_p.func_78256_a(\u26035) / 2, n, \u26034);
                }
            }
        } else {
            String string2 = (Object)((Object)TextFormatting.YELLOW) + "" + n4;
            this.field_175250_f.field_71466_p.func_238405_a_(matrixStack, string2, n3 - this.field_175250_f.field_71466_p.func_78256_a(string2), n, 0xFFFFFF);
        }
    }

    public void func_175248_a(@Nullable ITextComponent iTextComponent) {
        this.field_175255_h = iTextComponent;
    }

    public void func_175244_b(@Nullable ITextComponent iTextComponent) {
        this.field_175256_i = iTextComponent;
    }

    public void func_181030_a() {
        this.field_175256_i = null;
        this.field_175255_h = null;
    }

    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo networkPlayerInfo, NetworkPlayerInfo networkPlayerInfo2) {
            ScorePlayerTeam scorePlayerTeam = networkPlayerInfo.func_178850_i();
            \u2603 = networkPlayerInfo2.func_178850_i();
            return ComparisonChain.start().compareTrueFirst(networkPlayerInfo.func_178848_b() != GameType.SPECTATOR, networkPlayerInfo2.func_178848_b() != GameType.SPECTATOR).compare((Comparable)((Object)(scorePlayerTeam != null ? scorePlayerTeam.func_96661_b() : "")), (Comparable)((Object)(\u2603 != null ? \u2603.func_96661_b() : ""))).compare((Object)networkPlayerInfo.func_178845_a().getName(), (Object)networkPlayerInfo2.func_178845_a().getName(), String::compareToIgnoreCase).result();
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((NetworkPlayerInfo)object, (NetworkPlayerInfo)object2);
        }
    }
}

