/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundList;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.Validate;

public class SoundListSerializer
implements JsonDeserializer<SoundList> {
    public SoundList deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "entry");
        boolean \u26032 = JSONUtils.func_151209_a(jsonObject, "replace", false);
        String \u26033 = JSONUtils.func_151219_a(jsonObject, "subtitle", null);
        List<Sound> \u26034 = this.func_188733_a(jsonObject);
        return new SoundList(\u26034, \u26032, \u26033);
    }

    private List<Sound> func_188733_a(JsonObject jsonObject) {
        ArrayList arrayList = Lists.newArrayList();
        if (jsonObject.has("sounds")) {
            JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "sounds");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                if (JSONUtils.func_151211_a(jsonElement)) {
                    String string = JSONUtils.func_151206_a(jsonElement, "sound");
                    arrayList.add(new Sound(string, 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16));
                    continue;
                }
                arrayList.add(this.func_188734_b(JSONUtils.func_151210_l(jsonElement, "sound")));
            }
        }
        return arrayList;
    }

    private Sound func_188734_b(JsonObject jsonObject) {
        String string = JSONUtils.func_151200_h(jsonObject, "name");
        Sound.Type \u26032 = this.func_188732_a(jsonObject, Sound.Type.FILE);
        float \u26033 = JSONUtils.func_151221_a(jsonObject, "volume", 1.0f);
        Validate.isTrue((\u26033 > 0.0f ? 1 : 0) != 0, (String)"Invalid volume", (Object[])new Object[0]);
        float \u26034 = JSONUtils.func_151221_a(jsonObject, "pitch", 1.0f);
        Validate.isTrue((\u26034 > 0.0f ? 1 : 0) != 0, (String)"Invalid pitch", (Object[])new Object[0]);
        int \u26035 = JSONUtils.func_151208_a(jsonObject, "weight", 1);
        Validate.isTrue((\u26035 > 0 ? 1 : 0) != 0, (String)"Invalid weight", (Object[])new Object[0]);
        boolean \u26036 = JSONUtils.func_151209_a(jsonObject, "preload", false);
        boolean \u26037 = JSONUtils.func_151209_a(jsonObject, "stream", false);
        int \u26038 = JSONUtils.func_151208_a(jsonObject, "attenuation_distance", 16);
        return new Sound(string, \u26033, \u26034, \u26035, \u26032, \u26037, \u26036, \u26038);
    }

    private Sound.Type func_188732_a(JsonObject jsonObject, Sound.Type type) {
        \u2603 = type;
        if (jsonObject.has("type")) {
            \u2603 = Sound.Type.func_188704_a(JSONUtils.func_151200_h(jsonObject, "type"));
            Validate.notNull((Object)((Object)\u2603), (String)"Invalid type", (Object[])new Object[0]);
        }
        return \u2603;
    }

    public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return this.deserialize(jsonElement, type, jsonDeserializationContext);
    }
}

