/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BambooBlock
extends Block
implements IGrowable {
    protected static final VoxelShape field_220261_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape field_220262_b = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape field_220263_c = Block.func_208617_a(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final IntegerProperty field_220264_d = BlockStateProperties.field_222512_Y;
    public static final EnumProperty<BambooLeaves> field_220265_e = BlockStateProperties.field_222508_aF;
    public static final IntegerProperty field_220266_f = BlockStateProperties.field_208137_al;

    public BambooBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_220264_d, 0)).func_206870_a(field_220265_e, BambooLeaves.NONE)).func_206870_a(field_220266_f, 0));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_220264_d, field_220265_e, field_220266_f);
    }

    @Override
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Override
    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        VoxelShape voxelShape = blockState.func_177229_b(field_220265_e) == BambooLeaves.LARGE ? field_220262_b : field_220261_a;
        Vector3d \u26032 = blockState.func_191059_e(iBlockReader, blockPos);
        return voxelShape.func_197751_a(\u26032.field_72450_a, \u26032.field_72448_b, \u26032.field_72449_c);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        Vector3d vector3d = blockState.func_191059_e(iBlockReader, blockPos);
        return field_220263_c.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext2) {
        FluidState fluidState = blockItemUseContext2.func_195991_k().func_204610_c(blockItemUseContext2.func_195995_a());
        if (!fluidState.func_206888_e()) {
            return null;
        }
        BlockState \u26032 = blockItemUseContext2.func_195991_k().func_180495_p(blockItemUseContext2.func_195995_a().func_177977_b());
        if (\u26032.func_235714_a_(BlockTags.field_219749_R)) {
            BlockItemUseContext blockItemUseContext2;
            if (\u26032.func_203425_a(Blocks.field_222404_kP)) {
                return (BlockState)this.func_176223_P().func_206870_a(field_220264_d, 0);
            }
            if (\u26032.func_203425_a(Blocks.field_222405_kQ)) {
                int n = \u26032.func_177229_b(field_220264_d) > 0 ? 1 : 0;
                return (BlockState)this.func_176223_P().func_206870_a(field_220264_d, n);
            }
            BlockState \u26033 = blockItemUseContext2.func_195991_k().func_180495_p(blockItemUseContext2.func_195995_a().func_177984_a());
            if (\u26033.func_203425_a(Blocks.field_222405_kQ) || \u26033.func_203425_a(Blocks.field_222404_kP)) {
                return (BlockState)this.func_176223_P().func_206870_a(field_220264_d, \u26033.func_177229_b(field_220264_d));
            }
            return Blocks.field_222404_kP.func_176223_P();
        }
        return null;
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (!blockState.func_196955_c(serverWorld, blockPos)) {
            serverWorld.func_175655_b(blockPos, true);
        }
    }

    @Override
    public boolean func_149653_t(BlockState blockState) {
        return blockState.func_177229_b(field_220266_f) == 0;
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (blockState.func_177229_b(field_220266_f) != 0) {
            return;
        }
        if (random.nextInt(3) == 0 && serverWorld.func_175623_d(blockPos.func_177984_a()) && serverWorld.func_226659_b_(blockPos.func_177984_a(), 0) >= 9 && (\u2603 = this.func_220260_b(serverWorld, blockPos) + 1) < 16) {
            this.func_220258_a(blockState, serverWorld, blockPos, random, \u2603);
        }
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return iWorldReader.func_180495_p(blockPos.func_177977_b()).func_235714_a_(BlockTags.field_219749_R);
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (!blockState.func_196955_c(iWorld, blockPos)) {
            iWorld.func_205220_G_().func_205360_a(blockPos, this, 1);
        }
        if (direction == Direction.UP && blockState2.func_203425_a(Blocks.field_222405_kQ) && blockState2.func_177229_b(field_220264_d) > blockState.func_177229_b(field_220264_d)) {
            iWorld.func_180501_a(blockPos, (BlockState)blockState.func_235896_a_(field_220264_d), 2);
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public boolean func_176473_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        int n = this.func_220259_a(iBlockReader, blockPos);
        return n + (\u2603 = this.func_220260_b(iBlockReader, blockPos)) + 1 < 16 && iBlockReader.func_180495_p(blockPos.func_177981_b(n)).func_177229_b(field_220266_f) != 1;
    }

    @Override
    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    @Override
    public void func_225535_a_(ServerWorld serverWorld, Random random, BlockPos blockPos, BlockState blockState) {
        int n = this.func_220259_a(serverWorld, blockPos);
        \u2603 = this.func_220260_b(serverWorld, blockPos);
        \u2603 = n + \u2603 + 1;
        \u2603 = 1 + random.nextInt(2);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            BlockPos blockPos2 = blockPos.func_177981_b(n);
            BlockState \u26032 = serverWorld.func_180495_p(blockPos2);
            if (\u2603 >= 16 || \u26032.func_177229_b(field_220266_f) == 1 || !serverWorld.func_175623_d(blockPos2.func_177984_a())) {
                return;
            }
            this.func_220258_a(\u26032, serverWorld, blockPos2, random, \u2603);
            ++n;
            ++\u2603;
        }
    }

    @Override
    public float func_180647_a(BlockState blockState, PlayerEntity playerEntity, IBlockReader iBlockReader, BlockPos blockPos) {
        if (playerEntity.func_184614_ca().func_77973_b() instanceof SwordItem) {
            return 1.0f;
        }
        return super.func_180647_a(blockState, playerEntity, iBlockReader, blockPos);
    }

    protected void func_220258_a(BlockState blockState, World world, BlockPos blockPos, Random random, int n) {
        BlockState blockState2 = world.func_180495_p(blockPos.func_177977_b());
        BlockPos \u26032 = blockPos.func_177979_c(2);
        \u2603 = world.func_180495_p(\u26032);
        BambooLeaves \u26033 = BambooLeaves.NONE;
        if (n >= 1) {
            if (!blockState2.func_203425_a(Blocks.field_222405_kQ) || blockState2.func_177229_b(field_220265_e) == BambooLeaves.NONE) {
                \u26033 = BambooLeaves.SMALL;
            } else if (blockState2.func_203425_a(Blocks.field_222405_kQ) && blockState2.func_177229_b(field_220265_e) != BambooLeaves.NONE) {
                \u26033 = BambooLeaves.LARGE;
                if (\u2603.func_203425_a(Blocks.field_222405_kQ)) {
                    world.func_180501_a(blockPos.func_177977_b(), (BlockState)blockState2.func_206870_a(field_220265_e, BambooLeaves.SMALL), 3);
                    world.func_180501_a(\u26032, (BlockState)\u2603.func_206870_a(field_220265_e, BambooLeaves.NONE), 3);
                }
            }
        }
        int \u26034 = blockState.func_177229_b(field_220264_d) == 1 || \u2603.func_203425_a(Blocks.field_222405_kQ) ? 1 : 0;
        int \u26035 = n >= 11 && random.nextFloat() < 0.25f || n == 15 ? 1 : 0;
        world.func_180501_a(blockPos.func_177984_a(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_220264_d, \u26034)).func_206870_a(field_220265_e, \u26033)).func_206870_a(field_220266_f, \u26035), 3);
    }

    protected int func_220259_a(IBlockReader iBlockReader, BlockPos blockPos) {
        int n;
        for (n = 0; n < 16 && iBlockReader.func_180495_p(blockPos.func_177981_b(n + 1)).func_203425_a(Blocks.field_222405_kQ); ++n) {
        }
        return n;
    }

    protected int func_220260_b(IBlockReader iBlockReader, BlockPos blockPos) {
        int n;
        for (n = 0; n < 16 && iBlockReader.func_180495_p(blockPos.func_177979_c(n + 1)).func_203425_a(Blocks.field_222405_kQ); ++n) {
        }
        return n;
    }
}

