/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadInfo
extends ValueObject {
    private static final Logger field_230638_a_ = LogManager.getLogger();
    private static final Pattern field_243085_b = Pattern.compile("^[a-zA-Z][-a-zA-Z0-9+.]+:");
    private final boolean field_230639_b_;
    @Nullable
    private final String field_230640_c_;
    private final URI field_230641_d_;

    private UploadInfo(boolean bl, @Nullable String string, URI uRI) {
        this.field_230639_b_ = bl;
        this.field_230640_c_ = string;
        this.field_230641_d_ = uRI;
    }

    @Nullable
    public static UploadInfo func_230796_a_(String string) {
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject \u26032 = jsonParser.parse(string).getAsJsonObject();
            String \u26033 = JsonUtils.func_225171_a("uploadEndpoint", \u26032, null);
            if (\u26033 != null && (\u2603 = UploadInfo.func_243087_a(\u26033, \u2603 = JsonUtils.func_225172_a("port", \u26032, -1))) != null) {
                boolean bl = JsonUtils.func_225170_a("worldClosed", \u26032, false);
                String \u26034 = JsonUtils.func_225171_a("token", \u26032, null);
                return new UploadInfo(bl, \u26034, \u2603);
            }
        }
        catch (Exception exception) {
            field_230638_a_.error("Could not parse UploadInfo: " + exception.getMessage());
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    public static URI func_243087_a(String string, int n) {
        Matcher matcher = field_243085_b.matcher(string);
        String \u26032 = UploadInfo.func_243088_a(string, matcher);
        try {
            URI uRI = new URI(\u26032);
            int \u26033 = UploadInfo.func_243086_a(n, uRI.getPort());
            if (\u26033 != uRI.getPort()) {
                return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), \u26033, uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            field_230638_a_.warn("Failed to parse URI {}", (Object)\u26032, (Object)uRISyntaxException);
            return null;
        }
    }

    private static int func_243086_a(int n, int n2) {
        if (n != -1) {
            return n;
        }
        if (n2 != -1) {
            return n2;
        }
        return 8080;
    }

    private static String func_243088_a(String string, Matcher matcher) {
        if (matcher.find()) {
            return string;
        }
        return "http://" + string;
    }

    public static String func_243090_b(@Nullable String string) {
        JsonObject jsonObject = new JsonObject();
        if (string != null) {
            jsonObject.addProperty("token", string);
        }
        return jsonObject.toString();
    }

    @Nullable
    public String func_230795_a_() {
        return this.field_230640_c_;
    }

    public URI func_243089_b() {
        return this.field_230641_d_;
    }

    public boolean func_230799_c_() {
        return this.field_230639_b_;
    }
}

